<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\HomeController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Middleware\IsAdmin;
use Illuminate\Support\Facades\Artisan;




Route::get('reset', function (){
    Artisan::call('route:clear');
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('config:cache');
});

Route::prefix('User')->group(function () {

    Route::get('/', [HomeController::class, 'index'])->name('user.index');
    Route::get('/home', [HomeController::class, 'home'])->name('user.home');
});

Route::get('/login',[HomeController::class,'login'])->name('login');
Route::post('/login',[HomeController::class,'loginAdmin'])->name('login.Admin');
Route::get('/logout',[HomeController::class,'logout'])->name('logout');
Route::post('/search' , [HomeController::class , 'search'] )->name('search');
Route::get('/product/{id}' , [HomeController::class , 'product'] )->name('product');



Route::prefix('Admin')->middleware([IsAdmin::class])->group(function () {
    route::get('/index', [AdminController::class, 'index'])->name('admin.index');
    route::get('/create', [AdminController::class, 'create'])->name('admin.create');
    route::post('/store', [AdminController::class, 'store'])->name('admin.store');
    route::get('/edit/{id}', [AdminController::class, 'edit'])->name('admin.edit');
    route::Post('/update/{id}', [AdminController::class, 'update'])->name('admin.update');
    route::Post('/delete/{id}', [AdminController::class, 'delete'])->name('admin.delete');

});



