

@extends('layouts.master')

@section('content')


    <div class="row ">
        @forelse($products as $product)

            <div class="col-sm-6 col-md-4 mt-4 mb-4 t1">
                <div class="card h-100 text-center">
                    <div class="card-body d-flex flex-column">
                        <!-- Thumbnail -->
                        <a class="mb-2 " href="{{ route('product', $product->id) }}">
                            <img src="{{ asset('Admin/' . $product->image) }}"
                                 alt="{{ $product->name }}"
                                 style="max-width:100%; height:250px; object-fit:cover; border-radius:8px;">
                        </a>

                        <!-- Product Title -->
                        <a class="product-title d-block mb-2" href="{{ route('product', $product->id) }}">
                            {{ $product->name }}
                        </a>

                        <!-- Product Price -->
                        <p class="sale-price mt-auto mb-0">{{ number_format($product->price) }} تومان</p>
                    </div>
                </div>
            </div>

        @empty
            <div class="col-12 text-center">
                <p class="text-muted">محصولی یافت نشد</p>
            </div>
        @endforelse
    </div>

    @endsection

