@extends('layouts.master')
@section('title', 'محصولات')
@section('content')
    <main>
        <section class="container " style="padding-top: 300px" >

            <div class="row justify-content-center">

                @foreach ($products as $product)
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-3 ">
                        <div class="card h-100 shadow shadow-lg ">
                          <a  href="#" target="_blank"
                                 class="card-img-top d-block ratio ratio-1x1 rounded-top ax"
                                 style="background-image: url({{ asset('Admin/' . $product->image) }});
                                     background-size: cover;
                                     background-position: center;">
                            </a>

                            <div class="card-body">
                                <h5 class="text-nowrap text-truncate h">
                                    {{ $product->name }}
                                </h5>

                                <div class="scrollable-div p-2">
                                    <p>{{ $product->description }}</p>
                                </div>

                                <p class="sale-price my-2">
                                    {{ number_format($product->price) }} تومان
                                </p>
                            </div>
                        </div>
                    </div>

                @endforeach
            </div>

        </section>
    </main>
@endsection
