<?php

namespace App\Http\Controllers\User;
use App\Http\Controllers\Controller;
use App\Models\Product;

use App\Models\User;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Nette\Utils\Finder;

class HomeController extends Controller
{
   public function index(){
       return view('User.index');
   }
   public function home(){
       $products=Product::all();
       return view('User.home',compact('products'));
   }


   public function login(){
        return view('Auth.login');
   }
    public function loginAdmin(Request $request)
    {
        $user = User::Where('username', $request->username)->Where('password', $request->password)->Where('isAdmin', 1)->first();
        if ($user) {
            Auth::login($user);
            return redirect()->route('admin.index');
        }
        return back()->withErrors([
            'username' => 'نام کاربری یا رمز عبور اشتباه است.',
        ]);
    }
    public function logout(){
      Auth::logout();
      return redirect('login');

    }

    public function search(Request $request){

        $products = Product::where('name' , 'like' , '%'.$request['search'].'%')->get();
        return view('User.products' , compact('products'));
    }


}
